一、基础规范
1. 表存储引擎必须使用InnoDB
2. 表字符集默认使用utf8，必要时候使用utf8mb4
3. 禁止使用存储过程，视图，触发器，Event
4. 禁止在数据库中存储大文件，例如照片，可以将大文件存储在对象存储系统，数据库中存储路径
5. 禁止在线上环境做数据库压力测试
6. 测试，开发，线上数据库环境必须隔离

二、命名规范

1. 库名，表名，列名必须用小写，采用下划线分隔
2. 库名，表名，列名必须见名知义，长度不要超过32字符
3. 库备份必须以bak为前缀，以日期为后缀
4. 从库必须以-s为后缀
5. 备库必须以-ss为后缀

 

三、表设计规范

1. 单实例表个数必须控制在2000个以内
2. 单表分表个数必须控制在1024个以内
3. 表必须有主键，推荐使用UNSIGNED整数为主键
4. 禁止使用外键，如果要保证完整性，应由应用程式实现
5. 建议将大字段，访问频度低的字段拆分到单独的表中存储，分离冷热数据

四、列设计规范

1. 根据业务区分使用tinyint/int/bigint，分别会占用1/4/8字节
2. 根据业务区分使用char/varchar
3. 根据业务区分使用datetime/timestamp
4. 必须把字段定义为NOT NULL并设默认值
5. 使用INT UNSIGNED存储IPv4，不要用char(15)
6. 使用varchar(20)存储手机号，不要使用整数
7. 使用TINYINT来代替ENUM

五、索引规范

1. 唯一索引使用uniq_[字段名]来命名
2. 非唯一索引使用idx_[字段名]来命名
3. 单张表索引数量建议控制在5个以内
4. 组合索引字段数不建议超过5个
5. 不建议在频繁更新的字段上建立索引
6. 非必要不要进行JOIN查询，如果要进行JOIN查询，被JOIN的字段必须类型相同，并建立索引
7. 理解组合索引最左前缀原则，避免重复建设索引，如果建立了(a,b,c)，相当于建立了(a), (a,b), (a,b,c)

六、SQL规范

1. 禁止使用select *，只获取必要字段
2. insert必须指定字段，禁止使用insert into T values()
3. 隐式类型转换会使索引失效，导致全表扫描
4. 禁止在where条件列使用函数或者表达式
5. 禁止负向查询以及%开头的模糊查询
6. 禁止大表JOIN和子查询
7. 同一个字段上的OR必须改写问IN，IN的值必须少于50个
8. 应用程序必须捕获SQL异常
9. 千万不要 ORDER BY RAND()


